clear;
clc;
fullScriptPath = matlab.desktop.editor.getActiveFilename();
[folderPath, ~, ~] = fileparts(fullScriptPath);
%% FILE1
%nomefile
file1 = 'C2_2025-07-22_15-44-19.txt';
file2 = 'C2_2025-07-22_14-50-07.txt';
% Define the names of the files you want to read
filename1 = fullfile(folderPath, file1);
filename2 = fullfile(folderPath, file2);
% Importa i dati
data_import_1 = importdata(filename1,'\t');
data_import_2 = importdata(filename2,'\t');
% Visualizza i dati
data1=data_import_1.data(5:end,:);
disp(data_import_1);
data2=data_import_2.data(5:end,:);
disp(data_import_2);

%% GRAFICI
%pitch
figure(1)


subplot(4,1,1)
plot(data1(:,1)-data1(1,1),data1(:,7),"--k", 'LineWidth', 1.5)
hold on
plot(data1(:,1)-data1(1,1),data1(:,6),"k", 'LineWidth', 1.5)
hold on
plot(data2(:,1)-data2(1,1),data2(:,6),"--r", 'LineWidth', 1.5)
grid on
xlabel('time [s]');
ylabel('pitch [deg]');
legend('com','response','nominal', 'Location', 'southeast');
pbaspect([5 1 1]) % Aspect ratio X:Y:Z
set(gcf, 'Position', [100, 100, 800, 800]) % [x, y, width, height]
ylim([-21 1])

subplot(4,1,2)
plot(data1(:,1)-data1(1,1),data1(:,12),"k", 'LineWidth', 1.5)
hold on
plot(data2(:,1)-data2(1,1),data2(:,12),"--r", 'LineWidth', 1.5)
grid on
xlabel('time [s]');
ylabel('\deltae [deg]');
ylim([-20 27])
pbaspect([5 1 1]) % Aspect ratio X:Y:Z

subplot(4,1,3)
plot(data1(:,1)-data1(1,1),data1(:,25)/9.8*0.3048,"k", 'LineWidth', 1.5)
hold on
plot(data2(:,1)-data2(1,1),data2(:,25)/9.8*0.3048,"--r", 'LineWidth', 1.5)
grid on
xlabel('time [s]');
ylabel('acceleration [g]');
ylim([-9 9])
pbaspect([5 1 1]) % Aspect ratio X:Y:Z

subplot(4,1,4)
plot(data1(:,1)-data1(1,1),data1(:,28),"k", 'LineWidth', 1.5)
hold on
plot(data2(:,1)-data2(1,1),data2(:,28),"--r", 'LineWidth', 1.5)
grid on
xlabel('time [s]');
ylabel('wind [m/s]');
ylim([-15 15])
pbaspect([5 1 1]) % Aspect ratio X:Y:Z
